<?php $this->load->view('include/header'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js" ></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.min.js" ></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.1/js/dataTables.responsive.min.js" ></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.16/css/dataTables.bootstrap4.min.css"/>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.1/js/responsive.bootstrap4.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.1/css/responsive.bootstrap4.min.css"/> 
<script type="text/javascript">
		$(document).ready(function() {
		$.noConflict();
		$('#coins-info-table').dataTable( {
          "order": [0, 'asc'],
          "pageLength": 10,
          "bInfo" : false,
          "bProcessing": true,
		 "bDeferRender": true,
          
		} );
		} );
	</script> 
 <?php
	function custom_number_format($n, $precision = 2) {
        if ($n < 100000) {
        // Default
         $n_format = number_format($n);
        } else if ($n < 9000000) {
        // Thousand
        $n_format = number_format($n / 1000, $precision, '.', ''). 'K';
        } else if ($n < 900000000) {
        // Million
        $n_format = number_format($n / 1000000, $precision). 'M';
        } else if ($n < 900000000000) {
        // Billion
        $n_format = number_format($n / 1000000000, $precision). 'B';
        } else {
        // Trillion
        $n_format = number_format($n / 1000000000000, $precision). 'T';
    }
			return $n_format;
		}
	function custom_prc_format($n) {
        if ($n >= 1) {
        $n_format = number_format($n, 2);
        } else if ($n >= 0.1 && $n < 1) {
        $n_format = number_format($n, 3);
        } else if ($n >= 0.01 && $n < 0.1) {
        $n_format = number_format($n, 4);
        } else if ($n >= 0.001 && $n < 0.01) {
        $n_format = number_format($n, 6);
        } else if ($n >= 0.0001 && $n < 0.001) {
        $n_format = number_format($n, 8);
        }
        else {
        $n_format = number_format($n, 10);
    }
			return $n_format;
		}
?>
<div class="page-title py-3">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-12 text-center">
        <h1>
          Follow Your Favourite Cryptocurrencies
        </h1>
        <h6 class="pb-3">
          Track your favorite cryptocurrencies with ease. Stay updated on the latest prices, market capitalization, and performance of your selected coins all in one place. The coins in the watchlist stays for 30 days and watchlist does not work in incognito mode of the browser.
        </h6>

      </div>
    </div>        
  </div>    
</div>
<!-- Ad Code Top  -->
<div class="py-4">
<?php if($ads[0]['pref']==0 || $ads[0]['pref']==2) { ?>
        <div class="container">
            <div class="row justify-content-center">
				<?php echo  $ads[0]['header_ads']?>
            </div>    
		</div>
<?php } ?>
</div>
<!-- End Ad Code Top  -->
<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-12 text-left">
      <div class="py-2">
        <table id="coins-info-table" class="table table-striped table-bordered dt-responsive wrap" cellspacing="0" width="100%">
          <thead>
            <tr>
              <th>#</th>
              <th>Name</th>
              <th>Price</th>
              <th>Market Cap</th>
              <th>Available Supply</th>
              <th>Volume (24H)</th>
              <th>Change (24H)</th>
            </tr>
          </thead>		
        <tbody>
            <?php if (!empty($watchlist)): ?>
        
            <?php foreach ($watchlist as $coin_name): ?>
<?php
foreach ($coinWData->data as $res) {
    if ($res->id == $coin_name) {
        $coinrank = $res->rank;
        $coinname = $res->name;
        $coinprice = $res->priceUsd;
        $coinsymbol = $res->symbol;
        $coinmcap = $res->marketCapUsd;
        $coinchange = $res->changePercent24Hr;
        $coinvolume = $res->volumeUsd24Hr;
        $coinsupply = $res->supply;
        $coincode = $res->id;
        break; // Exit the loop early since we found the matching coin
    }
}
?>

                <?php  $img_src=base_url().'assets/images/coins/'.$coin_name.'.png';
			$file_path=FCPATH.'assets/images/coins/'.$coin_name.'.png';
			if (!file_exists($file_path)) $img_src=base_url().'assets/images/default.png';
			?>
             				<tr id="BTC_<?php echo $coinsymbol;?>">
					<td><a href="<?= site_url('watchlist/remove/' . $coin_name) ?>"><i class="fa fa-star" title="Remove from Watchlist"></i></a> <?php echo $coinrank;?></td>
					<td><img src="<?php echo $img_src ?>"><a href="<?php echo base_url() ?>coin/<?php echo $coincode; ?>"><span class="coin-name"><?php echo $coinname;?></span></a> <span class="badge badge-warning"><?php echo $coinsymbol;?></span></td>
					<td class="price" data-sort="<?php echo $coinprice;?>"><?php echo strtok($convertSymbol, " ");?><?php echo custom_prc_format($coinprice/$convertRate);?></td>
					<td data-sort="<?php echo $coinmcap;?>"><?php echo strtok($convertSymbol, " ");?><?php echo custom_number_format($coinmcap/$convertRate); ?></td>
					<td data-sort="<?php echo $coinsupply;?>"><?php echo custom_number_format($coinsupply); ?> <?php echo $coinsymbol;?></td>
					<td data-sort="<?php echo $coinvolume;?>"><?php echo strtok($convertSymbol, " ");?><?php echo custom_number_format($coinvolume/$convertRate); ?></td>
					<td data-sort="<?php echo $coinchange;?>"><span class="p-<?php echo $coinchange > 0 ? 'up':'down'?>"><i class="fa fa-caret-<?php echo $coinchange > 0 ? 'up':'down'?>"></i> <?php echo str_replace('-','',round($coinchange,2));?>%</span></td>
				</tr>       
                
                
            <?php endforeach; ?>
        
   		 <?php else: ?>
        <div class="alert alert-danger">Your watchlist is currently empty. Start adding your favorite cryptocurrencies to track their prices, market capitalization, and performance all in one place.</div>
    <?php endif; ?>
 

        </tbody>
		</table>  

	  </div>      
    </div>        
  </div>    
</div>


<!-- Ad Code Bottom  -->
<div class="py-4">
<?php if($ads[0]['pref']==1 || $ads[0]['pref']==2) { ?>
        <div class="container">
            <div class="row justify-content-center">
				<?php echo  $ads[0]['footer_ads']?>
            </div>    
		</div>
<?php } ?>
</div>
<!-- End Ad Code Bottom  -->
	<!-- News Section Start  -->
<div class="container pt-3 pb-5">
<h2 class="pb-2">Cryptocurrency Latest News & Updates</h2>
<div class="card-deck">
   <?php
   $i=1;
             setlocale(LC_MONETARY,"en_US");
             foreach ($newsData->channel->item as $res)
				{
				    if($i>3)
				    continue; 
					 ?>
<div style="padding-left:0px;padding-right:0px;" class="col-md-4">
<div style="margin-bottom:20px;padding-left:0px;padding-right:0px;min-height:500px;" class="card">
<img src="<?php echo $res->enclosure->{"@attributes"}->url;?>" class="card-img-left">
<div class="card-body">
<span class="badge linking"> <?php echo substr($res->pubDate, 0, 16);?> </span>
<h6 class="card-title"><?php echo $res->title;?></h6>
<p><?php echo strip_tags(substr($res->description, 0, 450));?>...</p>
<a href="<?php echo $res->link;?>" class="btn btn-warning" target="_blank">Read More</a>
</div></div></div>
	<?php
	++$i;
		}
				?>
</div>  
<a href="<?php echo base_url(); ?>news" class="btn btn-warning btn-block">View More</a>
</div>  
<!-- News Section End  -->
<!-- Donation Box  -->
<?php $this->load->view('include/donation'); ?>
<!-- End Donation Box  -->
<script src="<?php echo base_url(); ?>assets/js/front/jquery-3.3.1.slim.min.js"></script>
<?php $this->load->view('include/footer'); ?>
